-- new script file

local waveRaid = {}
local mission = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    mission.enemy = Citadels.GetPlayer(1)
		self.spawnPos = Game:GetEntity("spawnPos-3"):GetPosition()
    	
	  if not self.loaded then
		  self.active = false
			self.attCounter = 0
		  self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
	  end
  
  end
  
  if self.active then
		if self.attCounter > 1 then
			UpgradeWave(self)
		end
    InitializeWave(self)
		AttackWave(self)
		self.raid = 0
    self.active = false
  end  
end

function InitializeWave(self)
	if self.raid == 1 then
		waveRaid['unit_L_archer_L1'] = self.baseCount * 0.08
		waveRaid['unit_L_fman_L1'] = self.baseCount * 0.06
		self.attackPoint = Game:GetEntity("ironOverlook"):GetPosition()
	elseif self.raid == 1 then
		waveRaid['unit_L_arbalist_L1'] = self.baseCount * 0.06
		waveRaid['unit_L_fman_L1'] = self.baseCount * 0.08
		self.attackPoint = Game:GetEntity("stoneOverlook"):GetPosition()
	end
end

function UpgradeWave(self)
	self.baseCount = self.baseCount + 10
end

function AttackWave(self)
  for prefab,ammount in pairs(waveRaid) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self.spawnPos, 20)
end

function OnTrigger(self, source, target)
  if target == "raid" then
    if source == "raidIron" then
      self.raid = 1
    elseif source == "raidStone" then
      self.raid = 2
    end
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
		self.active = ar:Read()
		self.attCounter = ar:Read()
		self.baseCount = ar:Read()
  elseif (ar:IsSaving()) then
		ar:Write(self.active)
		ar:Write(self.attCounter)
		ar:Write(self.baseCount)
	end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("raid")
end
